//=============================================================================
// GhostieFragment.
//=============================================================================
class GhostieFragment expands DeusExFragment;

#exec TEXTURE IMPORT NAME="WhitePoop" FILE="C:\DeusEx\Legos\White.pcx" GROUP=Skins

auto state Flying
{
	function BeginState()
	{
		Super.BeginState();

		Velocity = VRand() * 300;
		DrawScale = FRand() + 1.5;
	}
}

function Tick(float deltaTime)
{
	Super.Tick(deltaTime);
	
	if (!IsInState('Dying'))
		if (FRand() < 0.2)
			Spawn(class'GhostieDrop',,, Location);
}

defaultproperties
{
     Fragments(0)=LodMesh'DeusExItems.FleshFragment1'
     Fragments(1)=LodMesh'DeusExItems.FleshFragment1'
     Fragments(2)=LodMesh'DeusExItems.FleshFragment1'
     Fragments(3)=LodMesh'DeusExItems.FleshFragment1'
     numFragmentTypes=4
     elasticity=0.400000
     ImpactSound=Sound'DeusExSounds.Generic.FleshHit1'
     MiscSound=Sound'DeusExSounds.Generic.FleshHit2'
     Mesh=LodMesh'DeusExItems.FleshFragment1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     Mass=5.000000
     Buoyancy=5.500000
     bVisionImportant=True
     Style=STY_Translucent
     MultiSkins(0)=Texture'WhitePoop'
     MultiSkins(1)=Texture'WhitePoop'
     MultiSkins(2)=Texture'WhitePoop'
     MultiSkins(3)=Texture'WhitePoop'
     MultiSkins(4)=Texture'WhitePoop'
     MultiSkins(5)=Texture'WhitePoop'
     MultiSkins(6)=Texture'WhitePoop'
     MultiSkins(7)=Texture'WhitePoop'
}
